﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <string>
#include <cmath>

using namespace std;

vector<vector<int>> gr;
vector<int> used;
int c0 = 0;
set<int> s;

struct point {
	int x, y;
	point(int _x, int _y) {
		x = _x;
		y = _y;
	}
	point() {}
	point(point A, point B) {
		x = B.x - A.x;
		y = B.y - A.y;
	}
	int operator*(point X) {
		return x * X.y - y * X.x;
	}
	int operator%(point X) {
		return x * X.x + y * X.y;
	}
};

struct otr {
	point A, B;
	otr(point _A, point _B) {
		A = _A;
		B = _B;
	}
	otr(){}
};

bool per_otr(otr q1, otr q2) {
	int c = 0;
	if (!(point(q1.B, q1.A) * point(q2.A, q1.A) * (point(q1.B, q1.A) * point(q2.B, q1.A)) <= 0)) c = 1;
	if (!(point(q2.B, q2.A) * point(q1.A, q2.A) * (point(q2.B, q2.A) * point(q1.B, q2.A)) <= 0)) c = 1;
	if (point(q1.A, q1.B) * point(q2.A, q2.B) == 0 && point(q1.A, q2.A) % point(q1.A, q2.B) == 1) c = 1;
	return !c;
}

vector<otr> z;

void dfs(int a) {
	used[a] = 1;
	s.insert(a);
	c0++;
	for (auto& i : gr[a]) {
		if (used[i] == 0) {
			dfs(i);
		}
	}
}

signed main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	int t;
	cin >> t;
	while (t--) {
		int n;
		cin >> n;
		z.assign(0, otr());
		gr.assign(n, vector<int>());
		used.assign(n, 0);
		c0 = 0;
		for (int i = 0; i < n; i++) {
			int x1, x2, y1, y2;
			cin >> x1 >> y1 >> x2 >> y2;
			point A(x1, y1), B(x2, y2);
			otr q(A, B);
			
			for (int i = 0; i < z.size(); i++) {
				if (per_otr(q, z[i])) {
					gr[i].push_back(z.size());
					gr[z.size()].push_back(i);
				}
			}
			z.push_back(q);
		}
		int ans = 0;
		for (int i = 0; i < n; i++) {
			if (used[i] == 0) {
				s.clear();
				c0 = 0;
				dfs(i);
				int q = 0;
				for (auto& i : s) {
					q += gr[i].size();
				}
				q /= 2;
				ans += (q - (c0 - 1));
			}
		}
		cout << ans + 1 << '\n';
	}
}
